model:setName( "CrossProcessing" )
model:caption( "Cross Processing" )

model:addSource("inputImage")

f1 = model:addFilter( "FilmTypes" )
f2 = model:addFilter( "LevelsAndCurvesFilter" )

-- Function for the Method combo box
function selectMethod(v)
  filter1 = model:getFilter(f1)
  lac = model:getFilter(f2)
   
  -- group title (C41 to E6)
  if( v==0 ) then  
  
  -- B01 (C41 to E6)
  elseif( v==1 ) then  

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0 )
    filter1:setFloatParameter( "saturationyellow", 0 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_B01 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_B01 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_B01 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_B01)	

	-- B02 (C41 to E6)
  elseif( v==2 ) then
  
    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0.08 )
    filter1:setFloatParameter( "saturationyellow", 0.04 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_B02 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_B02 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_B02 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_B02 )	

  -- B04 (C41 to E6)
  elseif( v==3 ) then
  
    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0 )
    filter1:setFloatParameter( "saturationyellow", 0 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_B04 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_B04 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_B04 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_B04 )	

  -- B05 (C41 to E6)
  elseif( v==4 ) then
  
    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.03 )
    filter1:setFloatParameter( "saturationyellow", -0.03 )
    filter1:setFloatParameter( "saturationgreen", -0.03 )
    filter1:setFloatParameter( "saturationcyan", -0.03 )
    filter1:setFloatParameter( "saturationblue", -0.04 )
    filter1:setFloatParameter( "saturationmagenta", -0.04 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_B05 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_B05 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_B05 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_B05 )	

  -- B10 (C41 to E6)
  elseif( v==5 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0.02 )
    filter1:setFloatParameter( "saturationyellow", 0 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", -0.02 )
    filter1:setFloatParameter( "saturationblue", -0.02 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_B10 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_B10 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_B10 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_B10 )	
  
  -- C04 (C41 to E6)
  elseif( v==6 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0.02 )
    filter1:setFloatParameter( "saturationyellow", 0.02 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0.02 )
    filter1:setFloatParameter( "saturationblue", 0.02 )
    filter1:setFloatParameter( "saturationmagenta", 0.02 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_C04 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_C04 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_C04 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_C04 )	

  -- G05 (C41 to E6)
  elseif( v==7 ) then
  
    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0 )
    filter1:setFloatParameter( "saturationyellow", 0.02 )
    filter1:setFloatParameter( "saturationgreen", 0.03 )
    filter1:setFloatParameter( "saturationcyan", 0.02 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_G05 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_G05 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_G05 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_G05 )	

  -- L02 (C41 to E6)
  elseif( v==8 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.03 )
    filter1:setFloatParameter( "saturationyellow", -0.03 )
    filter1:setFloatParameter( "saturationgreen", -0.03 )
    filter1:setFloatParameter( "saturationcyan", -0.03 )
    filter1:setFloatParameter( "saturationblue", -0.03 )
    filter1:setFloatParameter( "saturationmagenta", -0.03 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_L02 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_L02 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_L02 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_L02 )	

  -- L03 (C41 to E6)
  elseif( v==9 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.03 )
    filter1:setFloatParameter( "saturationyellow", -0.03 )
    filter1:setFloatParameter( "saturationgreen", -0.03 )
    filter1:setFloatParameter( "saturationcyan", -0.03 )
    filter1:setFloatParameter( "saturationblue", -0.03 )
    filter1:setFloatParameter( "saturationmagenta", -0.03 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_L03 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_L03 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_L03 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_L03 )	

  -- L08 (C41 to E6)
  elseif( v==10 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", -0.01 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0.07 )
    filter1:setFloatParameter( "saturationyellow", 0.05 )
    filter1:setFloatParameter( "saturationgreen", 0.04 )
    filter1:setFloatParameter( "saturationcyan", 0.04 )
    filter1:setFloatParameter( "saturationblue", 0.04 )
    filter1:setFloatParameter( "saturationmagenta", 0.06 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_L08 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_L08 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_L08 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_L08 )	

  -- LB04 (C41 to E6)
  elseif( v==11 ) then

    filter1:setFloatParameter( "sensitivityred", 0.24 )
    filter1:setFloatParameter( "sensitivityyellow", -0.22 )
    filter1:setFloatParameter( "sensitivitygreen", -0.42 )
    filter1:setFloatParameter( "sensitivitycyan", -0.35 )
    filter1:setFloatParameter( "sensitivityblue", -0.06 )
    filter1:setFloatParameter( "sensitivitymagenta", 0.25 )

    filter1:setFloatParameter( "saturationred", 0.04 )
    filter1:setFloatParameter( "saturationyellow", 0.02 )
    filter1:setFloatParameter( "saturationgreen", -0.02 )
    filter1:setFloatParameter( "saturationcyan", -0.02 )
    filter1:setFloatParameter( "saturationblue", -0.02 )
    filter1:setFloatParameter( "saturationmagenta", 0.02 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_LB04 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_LB04 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_LB04 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_LB04 )	

  -- LT04 (C41 to E6)
  elseif( v==12 ) then

    filter1:setFloatParameter( "sensitivityred", 0.24 )
    filter1:setFloatParameter( "sensitivityyellow", -0.22 )
    filter1:setFloatParameter( "sensitivitygreen", -0.42 )
    filter1:setFloatParameter( "sensitivitycyan", -0.35 )
    filter1:setFloatParameter( "sensitivityblue", -0.06 )
    filter1:setFloatParameter( "sensitivitymagenta", 0.25 )

    filter1:setFloatParameter( "saturationred", 0.04 )
    filter1:setFloatParameter( "saturationyellow", 0.02 )
    filter1:setFloatParameter( "saturationgreen", -0.02 )
    filter1:setFloatParameter( "saturationcyan", -0.02 )
    filter1:setFloatParameter( "saturationblue", -0.02 )
    filter1:setFloatParameter( "saturationmagenta", 0.02 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_LT04 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_LT04 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_LT04 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_LT04 )	
	
  -- T04 (C41 to E6)
  elseif( v==13 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.03 )
    filter1:setFloatParameter( "saturationyellow", -0.03 )
    filter1:setFloatParameter( "saturationgreen", -0.03 )
    filter1:setFloatParameter( "saturationcyan", -0.03 )
    filter1:setFloatParameter( "saturationblue", -0.04 )
    filter1:setFloatParameter( "saturationmagenta", 0.04 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_T04 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_T04 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_T04 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_T04 )	

  -- group title (E6 to C41)
  elseif( v==14 ) then

  -- C01 (E6 to C41)
  elseif( v==15 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0 )
    filter1:setFloatParameter( "saturationyellow", 0 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_C01 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_C01 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_C01 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_C01 )	

  -- L05 (E6 to C41)
  elseif( v==16 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.04 )
    filter1:setFloatParameter( "saturationyellow", -0.04 )
    filter1:setFloatParameter( "saturationgreen", -0.04 )
    filter1:setFloatParameter( "saturationcyan", -0.04 )
    filter1:setFloatParameter( "saturationblue", -0.04 )
    filter1:setFloatParameter( "saturationmagenta", -0.04 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_L05 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_L05 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_L05 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_L05 )	

  -- L07 (E6 to C41)
  elseif( v==17 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", -0.04 )
    filter1:setFloatParameter( "saturationyellow", -0.04 )
    filter1:setFloatParameter( "saturationgreen", -0.04 )
    filter1:setFloatParameter( "saturationcyan", -0.04 )
    filter1:setFloatParameter( "saturationblue", -0.04 )
    filter1:setFloatParameter( "saturationmagenta", -0.04 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_L07 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_L07 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_L07 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_L07 )	

  -- T01 (E6 to C41)
  elseif( v==18 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0 )
    filter1:setFloatParameter( "saturationyellow", 0 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_T01 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_T01 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_T01 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_T01 )	

  -- Y02 (E6 to C41)
  elseif( v==19 ) then

    filter1:setFloatParameter( "sensitivityred", 0 )
    filter1:setFloatParameter( "sensitivityyellow", 0 )
    filter1:setFloatParameter( "sensitivitygreen", 0 )
    filter1:setFloatParameter( "sensitivitycyan", 0 )
    filter1:setFloatParameter( "sensitivityblue", 0 )
    filter1:setFloatParameter( "sensitivitymagenta", 0 )

    filter1:setFloatParameter( "saturationred", 0.03 )
    filter1:setFloatParameter( "saturationyellow", 0.02 )
    filter1:setFloatParameter( "saturationgreen", -0.04 )
    filter1:setFloatParameter( "saturationcyan", -0.04 )
    filter1:setFloatParameter( "saturationblue", -0.04 )
    filter1:setFloatParameter( "saturationmagenta", -0.04 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_Y02 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_Y02 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_Y02 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_Y02 )	

  -- Y06 (E6 to C41)
  elseif( v==20 ) then

    filter1:setFloatParameter( "sensitivityred", 0.24 )
    filter1:setFloatParameter( "sensitivityyellow", -0.22 )
    filter1:setFloatParameter( "sensitivitygreen", -0.42 )
    filter1:setFloatParameter( "sensitivitycyan", -0.35 )
    filter1:setFloatParameter( "sensitivityblue", 0.06 )
    filter1:setFloatParameter( "sensitivitymagenta", 0.25 )

    filter1:setFloatParameter( "saturationred", 0.03 )
    filter1:setFloatParameter( "saturationyellow", 0.03 )
    filter1:setFloatParameter( "saturationgreen", 0 )
    filter1:setFloatParameter( "saturationcyan", 0 )
    filter1:setFloatParameter( "saturationblue", 0 )
    filter1:setFloatParameter( "saturationmagenta", 0.03 )

    filter1:setFloatParameter( "brightness", 0 )
    filter1:setFloatParameter( "contrastslider", 0 )
  
	lac:setLacData( "lacdataRGB", curveCrossProcessing_Lum_Y06 )
	lac:setLacData( "lacdataR", curveCrossProcessing_Red_Y06 )
	lac:setLacData( "lacdataG", curveCrossProcessing_Green_Y06 )
	lac:setLacData( "lacdataB", curveCrossProcessing_Blue_Y06 )	

  end

end
model:addGroupedCombobox( 	"Method", "selectMethod", "Method", "B01;B02;B04;B05;B10;C04;G05;L02;L03;L08;LB04;LT04;T04;C01;L05;L07;T01;Y02;Y06", "C41 to E6;;;;;;;;;;;;;E6 to C41;;;;;;", "C41toE6-B01;C41toE6-B02;C41toE6-B04;C41toE6-B05;C41toE6-B10;C41toE6-C04;C41toE6-G05;C41toE6-L02;C41toE6-L03;C41toE6-L08;C41toE6-LB04;C41toE6-LT04;C41toE6-T04;E6toC41-C01;E6toC41-L05;E6toC41-L07;E6toC41-T01;E6toC41-Y02;E6toC41-Y06"
						)

function cpStrength(v)
  lac = model:getFilter(f2)
  lac:setFloatParameter( "strength", v*100 )
end
model:addFloatSlider(	"CrossProcessingStrength", 0.33,0,1, "cpStrength", "Strength", "" )

					
model:forwardParameter("protect_shadows", f1 ,"protect_shadows", "Shadows", "")					  
model:forwardParameter("protect_hilights", f1 ,"protect_hilights", "Highlights", "")
	  
				  
-- B01 (C41 to E6)
curveCrossProcessing_Lum_B01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.15"/>
	<key name="intNodeY0" value="0.1"/>
	<key name="intNodeX1" value="0.75"/>
	<key name="intNodeY1" value="0.81875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_B01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0.12500"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="0.83750"/>
	<key name="highNodeY" value="0.82500"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.51250"/>
	<key name="intNodeY0" value="0.38125"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_B01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.18125"/>
	<key name="intNodeY0" value="0.21875"/>
	<key name="intNodeX1" value="0.74375"/>
	<key name="intNodeY1" value="0.68750"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_B01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.12500"/>
	<key name="highNodeX" value="0.88125"/>
	<key name="highNodeY" value="0.97500"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.21875"/>
	<key name="intNodeY0" value="0.26250"/>
	<key name="intNodeX1" value="0.52500"/>
	<key name="intNodeY1" value="0.76875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
							  
-- B02 (C41 to E6)
curveCrossProcessing_Lum_B02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.20625"/>
	<key name="intNodeY0" value="0.15000"/>
	<key name="intNodeX1" value="0.76875"/>
	<key name="intNodeY1" value="0.81875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_B02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.27500"/>
	<key name="intNodeY0" value="0.16785"/>
	<key name="intNodeX1" value="0.83125"/>
	<key name="intNodeY1" value="0.86875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_B02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.46875"/>
	<key name="intNodeY0" value="0.50625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_B02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.06875"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.90625"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.06250"/>
	<key name="intNodeY0" value="0.18125"/>
	<key name="intNodeX1" value="0.31875"/>
	<key name="intNodeY1" value="0.44375"/>
	<key name="intNodeX2" value="0.87500"/>
	<key name="intNodeY2" value="0.78125"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- B04 (C41 to E6)
curveCrossProcessing_Lum_B04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_B04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.53125"/>
	<key name="intNodeY0" value="0.37500"/>
	<key name="intNodeX1" value="0.87500"/>
	<key name="intNodeY1" value="0.93750"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_B04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.83750"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.44375"/>
	<key name="intNodeY0" value="0.29375"/>
	<key name="intNodeX1" value="0.80000"/>
	<key name="intNodeY1" value="0.72500"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_B04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.16875"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.90625"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.51875"/>
	<key name="intNodeY0" value="0.57500"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
			
-- B05 (C41 to E6)			
curveCrossProcessing_Lum_B05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.20625"/>
	<key name="intNodeY0" value="0.18125"/>
	<key name="intNodeX1" value="0.78750"/>
	<key name="intNodeY1" value="0.84375"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_B05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.53750"/>
	<key name="intNodeY0" value="0.47500"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_B05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.84375"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.55625"/>
	<key name="intNodeY0" value="0.50625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_B05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.96875"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.16250"/>
	<key name="intNodeY0" value="0.28750"/>
	<key name="intNodeX1" value="0.36250"/>
	<key name="intNodeY1" value="0.54375"/>
	<key name="intNodeX2" value="0.83750"/>
	<key name="intNodeY2" value="0.81875"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- B10 (C41 to E6)
curveCrossProcessing_Lum_B10 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.21875"/>
	<key name="intNodeY0" value="0.20000"/>
	<key name="intNodeX1" value="0.83750"/>
	<key name="intNodeY1" value="0.90000"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_B10 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.63125"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.55000"/>
	<key name="intNodeY0" value="0.22500"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_B10 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.60000"/>
	<key name="intNodeY0" value="0.44375"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_B10 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.53750"/>
	<key name="intNodeY0" value="0.74375"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- C04 (C41 to E6)
curveCrossProcessing_Lum_C04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.45625"/>
	<key name="intNodeY0" value="0.40625"/>
	<key name="intNodeX1" value="0.59375"/>
	<key name="intNodeY1" value="0.68750"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_C04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.52500"/>
	<key name="intNodeY0" value="0.47500"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_C04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.48750"/>
	<key name="intNodeY0" value="0.49375"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_C04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.08750"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.79375"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.14375"/>
	<key name="intNodeY0" value="0.25000"/>
	<key name="intNodeX1" value="0.67500"/>
	<key name="intNodeY1" value="0.66250"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- G05 (C41 to E6)
curveCrossProcessing_Lum_G05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.71250"/>
	<key name="intNodeY0" value="0.66250"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_G05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.68125"/>
	<key name="intNodeY0" value="0.58750"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_G05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.01250"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.8250"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.11875"/>
	<key name="intNodeY0" value="0.25625"/>
	<key name="intNodeX1" value="0.31875"/>
	<key name="intNodeY1" value="0.50000"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_G05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.78750"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.69375"/>
	<key name="intNodeY0" value="0.65625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- L02 (C41 to E6)
curveCrossProcessing_Lum_L02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.18125"/>
	<key name="intNodeY0" value="0.15625"/>
	<key name="intNodeX1" value="0.28125"/>
	<key name="intNodeY1" value="0.30625"/>
	<key name="intNodeX2" value="0.80625"/>
	<key name="intNodeY2" value="0.93125"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_L02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_L02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_L02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.08750"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.91250"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.14375"/>
	<key name="intNodeY0" value="0.25000"/>
	<key name="intNodeX1" value="0.67500"/>
	<key name="intNodeY1" value="0.66250"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- L03 (C41 to E6)
curveCrossProcessing_Lum_L03 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.19375"/>
	<key name="intNodeY0" value="0.15625"/>
	<key name="intNodeX1" value="0.28125"/>
	<key name="intNodeY1" value="0.30625"/>
	<key name="intNodeX2" value="0.86875"/>
	<key name="intNodeY2" value="0.98125"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_L03 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_L03 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_L03 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.53125"/>
	<key name="intNodeY0" value="0.60625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- L08 (C41 to E6)
curveCrossProcessing_Lum_L08 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="4"/>
	<key name="intNodeX0" value="0.09375"/>
	<key name="intNodeY0" value="0.08750"/>
	<key name="intNodeX1" value="0.17500"/>
	<key name="intNodeY1" value="0.32500"/>
	<key name="intNodeX2" value="0.34375"/>
	<key name="intNodeY2" value="0.75000"/>
	<key name="intNodeX3" value="0.51875"/>
	<key name="intNodeY3" value="0.91250"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_L08 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.60000"/>
	<key name="intNodeY0" value="0.55625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_L08 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.60000"/>
	<key name="intNodeY0" value="0.60625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_L08 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.03750"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.38125"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.06875"/>
	<key name="intNodeY0" value="0.12500"/>
	<key name="intNodeX1" value="0.44375"/>
	<key name="intNodeY1" value="0.33750"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- LB04 (C41 to E6)
curveCrossProcessing_Lum_LB04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.22500"/>
	<key name="intNodeY0" value="0.31250"/>
	<key name="intNodeX1" value="0.86250"/>
	<key name="intNodeY1" value="0.95000"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_LB04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.63125"/>
	<key name="intNodeY0" value="0.55625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_LB04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_LB04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.28125"/>
	<key name="intNodeY0" value="0.50000"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- LT04 (C41 to E6)
curveCrossProcessing_Lum_LT04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.49375"/>
	<key name="intNodeY0" value="0.65625"/>
	<key name="intNodeX1" value="0.83750"/>
	<key name="intNodeY1" value="0.94375"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_LT04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.61875"/>
	<key name="intNodeY0" value="0.51250"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_LT04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.41250"/>
	<key name="intNodeY0" value="0.45000"/>
	<key name="intNodeX1" value="0.74375"/>
	<key name="intNodeY1" value="0.80625"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_LT04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.58750"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.10000"/>
	<key name="intNodeY0" value="0.18125"/>
	<key name="intNodeX1" value="0.68750"/>
	<key name="intNodeY1" value="0.56250"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- T04 (C41 to E6)
curveCrossProcessing_Lum_T04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.16250"/>
	<key name="intNodeY0" value="0.08750"/>
	<key name="intNodeX1" value="0.80000"/>
	<key name="intNodeY1" value="0.90000"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_T04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.30000"/>
	<key name="intNodeY0" value="0.25000"/>
	<key name="intNodeX1" value="0.83750"/>
	<key name="intNodeY1" value="0.82500"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_T04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.17500"/>
	<key name="intNodeY0" value="0.25000"/>
	<key name="intNodeX1" value="0.88125"/>
	<key name="intNodeY1" value="0.81875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_T04 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.12500"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.78750"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.05625"/>
	<key name="intNodeY0" value="0.21875"/>
	<key name="intNodeX1" value="0.76875"/>
	<key name="intNodeY1" value="0.61875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- C01 (E6 to C41)
curveCrossProcessing_Lum_C01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.25625"/>
	<key name="intNodeY0" value="0.22500"/>
	<key name="intNodeX1" value="0.74375"/>
	<key name="intNodeY1" value="0.83750"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_C01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.39375"/>
	<key name="intNodeY0" value="0.28125"/>
	<key name="intNodeX1" value="0.50000"/>
	<key name="intNodeY1" value="0.48750"/>
	<key name="intNodeX2" value="0.65625"/>
	<key name="intNodeY2" value="0.76250"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_C01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.91875"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.28750"/>
	<key name="intNodeY0" value="0.16250"/>
	<key name="intNodeX1" value="0.44375"/>
	<key name="intNodeY1" value="0.43750"/>
	<key name="intNodeX2" value="0.61250"/>
	<key name="intNodeY2" value="0.73125"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_C01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.12500"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.36250"/>
	<key name="intNodeY0" value="0.10000"/>
	<key name="intNodeX1" value="0.71250"/>
	<key name="intNodeY1" value="0.78750"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- L05 (E6 to C41)
curveCrossProcessing_Lum_L05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.22500"/>
	<key name="intNodeY0" value="0.12500"/>
	<key name="intNodeX1" value="0.60000"/>
	<key name="intNodeY1" value="0.77500"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_L05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_L05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.52500"/>
	<key name="intNodeY0" value="0.55625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_L05 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.03125"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.75000"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.33750"/>
	<key name="intNodeY0" value="0.34375"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- L07 (E6 to C41)
curveCrossProcessing_Lum_L07 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.09375"/>
	<key name="intNodeY0" value="0.08750"/>
	<key name="intNodeX1" value="0.20625"/>
	<key name="intNodeY1" value="0.33750"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_L07 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.59375"/>
	<key name="intNodeY0" value="0.52500"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_L07 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.60000"/>
	<key name="intNodeY0" value="0.60625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_L07 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.03750"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.60625"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.06875"/>
	<key name="intNodeY0" value="0.12500"/>
	<key name="intNodeX1" value="0.45625"/>
	<key name="intNodeY1" value="0.41250"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- T01 (E6 to C41)
curveCrossProcessing_Lum_T01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.18125"/>
	<key name="intNodeY0" value="0.16875"/>
	<key name="intNodeX1" value="0.80625"/>
	<key name="intNodeY1" value="0.81875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_T01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.53750"/>
	<key name="intNodeY0" value="0.50000"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_T01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.56250"/>
	<key name="intNodeY0" value="0.59375"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_T01 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.03750"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.85625"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.06875"/>
	<key name="intNodeY0" value="0.12500"/>
	<key name="intNodeX1" value="0.87500"/>
	<key name="intNodeY1" value="0.75000"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- Y02 (E6 to C41)
curveCrossProcessing_Lum_Y02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.12500"/>
	<key name="intNodeY0" value="0.06875"/>
	<key name="intNodeX1" value="0.93750"/>
	<key name="intNodeY1" value="0.96875"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_Y02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_Y02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.50625"/>
	<key name="intNodeY0" value="0.56250"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_Y02 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.65000"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.25625"/>
	<key name="intNodeY0" value="0.25625"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- Y06 (E6 to C41)
curveCrossProcessing_Lum_Y06 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Red_Y06 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.65000"/>
	<key name="intNodeY0" value="0.54375"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Green_Y06 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.50000"/>
	<key name="intNodeY0" value="0.38750"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveCrossProcessing_Blue_Y06 = [[ 
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.45000"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.09375"/>
	<key name="intNodeY0" value="0.12500"/>
	<key name="intNodeX1" value="0.40000"/>
	<key name="intNodeY1" value="0.35625"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

-- sets default parameter
selectMethod(1)
model:setIntParameter("Method",2)